﻿using AZVIC.Ei8htPOS.BAL;
using AZVIC.Ei8htPOS.Entities;
using AZVIC.Ei8htPOS.WebUI.Admin.Helpers;
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace AZVIC.Ei8htPOS.WebUI.Admin.Masters.SubCategory
{
    public partial class SubCategories : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
          WebSession.RedirectToAdminDashBoard(false);

            if (!IsPostBack)
            {
                BindProductSubCategoryList(string.Empty);
            }
        }

        private void BindProductSubCategoryList(string searchWord)
        {
            List<ProductSubCategory> pcList = ProductSubCategoryBL.GetList(Guid.Empty, Guid.Empty, searchWord);
            pcList = (from pb in pcList
                      where pb.IsActive
                      orderby pb.SubCategoryName ascending
                      select pb).ToList<ProductSubCategory>();
            grdProductSubCategory.DataSource = pcList;//.OrderBy(reg => reg.SequenceNo);
            grdProductSubCategory.DataBind();

            if (pcList.Count == 0)
                WebUtilities.ShowMessage(this, "No Product Sub Category found");
        }

        protected void btnExportToExcel(object sender, EventArgs e)
        {
            BindProductSubCategoryList(string.Empty);
            Master.ExportToExcel<Entities.ProductSubCategory>(grdProductSubCategory, "SubCategoryReport");
        }

        protected void grdProductSubCategory_PageIndexChanging(object sender, GridViewPageEventArgs e)
        {
            grdProductSubCategory.PageIndex = e.NewPageIndex;
            BindProductSubCategoryList(txtSearch.Text.Trim());
        }

        protected void grdProductSubCategory_RowDataBound(object sender, GridViewRowEventArgs e)
        {
            if (e.Row.RowType == DataControlRowType.DataRow)
            {
                Label lblCategoryName = e.Row.FindControl("lblCategoryName") as Label;

                Guid pcategoryID = ((ProductSubCategory)e.Row.DataItem).ProductCategoryID;
                lblCategoryName.Text = ProductCategoryBL.GetItem(pcategoryID, string.Empty).CategoryName;
            }
        }

        protected void btnSearch_Click(object sender, EventArgs e)
        {
            if (txtSearch.Text.Trim().Length == 0)
            {
                WebUtilities.ShowMessage(this, "Please enter the search word");
                return;
            }
            BindProductSubCategoryList(txtSearch.Text.Trim());
        }

        protected void btnShowAll_Click(object sender, EventArgs e)
        {
            BindProductSubCategoryList(string.Empty);
        }
    }
}